penalty();
/* This scoring script is for the dual-occupant scenario found in the CNCAP Management Regulation 1.2.1.5.4
 * Which gives penalties for the Far Side Occupant Protection Assessment.
 * In this script we do the DRIVER side and use the Far Side Pole protocol. (Side Pole covers the FRONT_PASSENGER side).
 * In this script we use the ES-2re dummy. (WSID is the other option for the dummy).
 * Related scripts are in: Side Pole (WSID), Side Pole (ES-2RE), Far Side Pole (WSID), Far Side Pole (ES-2RE) */

function penalty() {
    let template = Template.GetCurrent();

    /**
     * The get_variable_value function returns English language constants,
     * e.g., "Pass" for %[PASS]% and "Fail" for %[FAIL]%.
     * Therefore, we should use english language constants for pass/fail below instead of using language constants.
     */
    let pass = "Pass";
    let fail = "Fail";

    /* Create a status object to track whether REPORTER Variables are all present and valid.
     * <success> is initially true but will be set to false if anything missing or invalid. */
    let status = { success: true, missing: [], invalid: [] };

    /* Work out highest chest and abdomen force and viscous criterion values*/
    let high_chest_compression = get_variable_value(status, "M1_DRIVER_CHEST_COMPRESSION_UPPER_MAX_VALUE", "float");
    let mid_chest_compression = get_variable_value(status, "M1_DRIVER_CHEST_COMPRESSION_MIDDLE_MAX_VALUE", "float");
    let low_chest_compression = get_variable_value(status, "M1_DRIVER_CHEST_COMPRESSION_LOWER_MAX_VALUE", "float");
    let high_chest_vc = get_variable_value(status, "M1_DRIVER_CHEST_VISCOUS_CRITERION_UPPER_MAX_VALUE", "float");
    let mid_chest_vc = get_variable_value(status, "M1_DRIVER_CHEST_VISCOUS_CRITERION_MIDDLE_MAX_VALUE", "float");
    let low_chest_vc = get_variable_value(status, "M1_DRIVER_CHEST_VISCOUS_CRITERION_LOWER_MAX_VALUE", "float");

    let max_chest_compression = Math.max(high_chest_compression, mid_chest_compression, low_chest_compression);
    let max_chest_vc = Math.max(high_chest_vc, mid_chest_vc, low_chest_vc);

    new Variable(
        template,
        "M1_CHEST_MAX_COMPRESSION",
        "Max chest compression",
        max_chest_compression.toString(),
        "General",
        false,
        true
    );

    new Variable(
        template,
        "M1_CHEST_MAX_VC",
        "Max chest viscous criterion",
        max_chest_vc.toString(),
        "General",
        false,
        true
    );

    /* Get all the other values to work out if they have broken the limit */
    let head_hic = get_variable_value(status, "M1_DRIVER_HEAD_HIC_HIC_VALUE", "float");
    let head_tms = get_variable_value(status, "M1_DRIVER_HEAD_THREE_MS_EXCEEDENCE_3MS_VALUE", "float");
    // max_chest_compression, max_chest_vc calculated above
    let abdomen_force = get_variable_value(status, "M1_DRIVER_ABDOMEN_FORCE_MAX_VALUE", "float");
    let pelvis_pubic_force = get_variable_value(status, "M1_DRIVER_PELVIS_FORCE_MAX_VALUE", "float");

    /* Set pass/fail for each of the indicators */
    if (Number(head_hic) > 1000 || Number.isNaN(Number(head_hic))) {
        var head_hic_result = fail;
    } else {
        var head_hic_result = pass;
    }

    if (Number(head_tms) > 88 || Number.isNaN(Number(head_tms))) {
        var head_tms_result = fail;
    } else {
        var head_tms_result = pass;
    }

    if (Number(max_chest_compression) > 44 || Number.isNaN(Number(max_chest_compression))) {
        var chest_compression_result = fail;
    } else {
        var chest_compression_result = pass;
    }

    if (Number(max_chest_vc) > 1 || Number.isNaN(Number(max_chest_vc))) {
        var chest_vc_result = fail;
    } else {
        var chest_vc_result = pass;
    }

    if (Number(abdomen_force) > 2.5 || Number.isNaN(Number(abdomen_force))) {
        var abdomen_force_result = fail;
    } else {
        var abdomen_force_result = pass;
    }

    if (Number(pelvis_pubic_force) > 6 || Number.isNaN(Number(pelvis_pubic_force))) {
        var pelvis_pubic_force_result = fail;
    } else {
        var pelvis_pubic_force_result = pass;
    }

    /* Calculate penalty */
    let penalty = 0;
    if (head_hic_result == fail || head_tms_result == fail) {
        penalty = -0.5;
        /* For the purposes of the summary template, it is actually a 1 penalty for this, but it gets capped to 0.5 */
        new Variable(template, "SUMMARY_HEAD_SCORE", "Head penalty", "-1", "General", false, true);
    } else {
        new Variable(template, "SUMMARY_HEAD_SCORE", "Head penalty", "0", "General", false, true);
    }

    if (
        chest_compression_result == fail ||
        chest_vc_result == fail ||
        abdomen_force_result == fail ||
        pelvis_pubic_force_result == fail
    ) {
        penalty = -0.5;
        new Variable(template, "SUMMARY_THORAX_ABDOMEN_SCORE", "Chest penalty", "-0.5", "General", false, true);
    } else {
        new Variable(template, "SUMMARY_THORAX_ABDOMEN_SCORE", "Chest penalty", "0", "General", false, true);
    }

    new Variable(template, "M1_HEAD_HIC_RESULT", "Head HIC result", head_hic_result, "General", false, true);

    new Variable(template, "M1_HEAD_TMS_RESULT", "Head TMS result", head_tms_result, "General", false, true);

    new Variable(
        template,
        "M1_CHEST_COMPRESSION_RESULT",
        "Chest compression result",
        chest_compression_result,
        "General",
        false,
        true
    );

    new Variable(template, "M1_CHEST_VC_RESULT", "Chest VC result", chest_vc_result, "General", false, true);

    new Variable(
        template,
        "M1_ABDOMEN_FORCE_RESULT",
        "Abdomen compression result",
        abdomen_force_result,
        "General",
        false,
        true
    );

    new Variable(
        template,
        "M1_PELVIS_PUBIC_FORCE_RESULT",
        "Pelvis pubic force result",
        pelvis_pubic_force_result,
        "General",
        false,
        true
    );

    new Variable(template, "SUMMARY_TOTAL_SCORE", "Penalty", penalty.toString(), "General", false, true);

    if (penalty == 0.0) {
        new Variable(template, "OVERALL_RESULT", "Overall Pass or Fail", pass, "General", false, true);
    } else {
        new Variable(template, "OVERALL_RESULT", "Overall Pass or Fail", fail, "General", false, true);
    }

    new Variable(
        template,
        "SUMMARY_NAME",
        "Working condition name for summary template",
        "%[DRIVER_AIRBAG_PENALTY]%",
        "General",
        false,
        true
    );

    /* Extra variables required otherwise the summary template gets errors */
    new Variable(template, "SUMMARY_HEAD_OFFSET", "Error Prevention", "", "General", false, true);
    new Variable(template, "CFA", "Error Prevention", "", "General", false, true);
    new Variable(template, "SUMMARY_TEST_INPUT", "Error Prevention", "", "General", false, true);
    new Variable(template, "SUMMARY_DUMMY_SETTINGS", "Error Prevention", "", "General", false, true);
    new Variable(template, "SUMMARY_SEAT_POSITION", "Error Prevention", "", "General", false, true);
}
